# Building an OpenWrt Image with Suricata

This guide explains how to build an OpenWrt image with Suricata installed. Tested on Ubuntu 24.04.1 and Kali 6.8.11.

## Prerequisites

Ensure you have installed the required build dependencies for the OpenWrt build system:  
- Follow the [OpenWrt Build System Requirements](https://openwrt.org/docs/guide-developer/toolchain/install-buildsystem).  
- Install additional packages: `curl` and `qemu-utils`.

---

## Steps

### 1. Clone the OpenWrt Repository

Clone the OpenWrt repository. This guide uses OpenWrt V23.05.5.  

For setup instructions, refer to the [OpenWrt Build System Guide](https://openwrt.org/docs/guide-developer/toolchain/use-buildsystem).

### 2. Update and Install Feeds

Run the following commands to prepare the feeds:
```bash
./scripts/feeds update -a
./scripts/feeds install -a
```

### 3. Add Suricata Feeds

Place the `suricata` and `suricata-update` feeds in the `/feeds/packages/net/` directory.  
Modify the package's Makefile if you want to use a specific version, if you want to compile for x86_64 or if you want the original suricata.

### 4. Update Feeds Index

Run:
```bash
./scripts/feeds update -a -i
./scripts/feeds install -a
```

### 5. Open Configuration Menu

Launch the configuration menu:
```bash
make menuconfig
```

### 6. Configure Target Settings

For building an image for Raspberry Pi 3 set 
- **Target System**: `Broadcom BCM27xx`  
- **SubTarget**: `BCM2710 boards (64 bits)`
- **Target Profile**: `Raspberry Pi 2B-1.2 (64bit) (Raspberry Pi 3B/3B+/CM3 (64bit))` and `Raspberry Pi 3B/3B+/CM3 (64bit)`  .

Instead for a VirtualBox VM:
- **Target System**: `x86`  
- **SubTarget**: `x86_64`  
- **Target Profile**: `Generic x86/64`  

### 7. Advanced Configuration Options

In the menu, enable the following under "Advanced configuration options":  
- **BPF Toolchain**: Build LLVM toolchain for eBPF.  

### 8. Library Configuration

Under "Libraries," enable `libintl-full`.

### 9. Global Build Settings

In "Global build settings," enable the following:  
- "Compile with Full language support."  
- In "Kernel build options," enable "XDP sockets support."  

### 10. Select Suricata Packages

Under **Network > Firewall**, enable:  
- `suricata`  
- `suricata-update`  

### 11. Set Root Filesystem Size

To avoid space issues:  
- Under **Target Images**, increase "Root filesystem partition size" (e.g., to `208MiB`).  

### 12. Include LuCI Packages

Under **LuCI > Collections**, enable:  
- `luci`.  

(Optional) For a minimal file browser:  
- Clone `https://github.com/openwrt/luci`.  
- Copy `applications/luci-app-filemanager` to `feeds/luci/applications/`.  
- Update feeds and configuration, and select `luci-app-filemanager` under **LuCI > Applications**.  

### 13. Optional: Set Root Password

The default root password is empty. To set a password:  
1. Generate a hashed password:
   ```bash
   openssl passwd -1 {passwd}
   ```
2. Copy the hash and edit `/package/base-files/files/etc/shadow`, replacing `root` with:
   ```plaintext
   root:{hash}:0:0:99999:7:::
   ```

### 14. Optional: Enable AP behaviour by Default

WiFi is disabled by default. To enable:  
- Edit `package/kernel/mac80211/files/lib/wifi/mac80211.sh`.  
- Set `set wireless.${name}.disabled` to `0`.  
- (Optional) Change the SSID: `set wireless.default_${name}.ssid`.

### 15. Optional: VirtualBox Support

To create a `.vdi` image for VirtualBox:  
- Uncheck `GZip images`.  
- Check `Build VirtualBox image files` under `Target Images`.  

### 16. Start the Build Process
Before running the build you should change Rust's feed:
- Under **openwrt/feeds/packages/lang/rust** modify the Makefile setting "--set=llvm.download-ci-llvm" to false  

Run the build process:  
```bash
make -j$(nproc) download world V=sc
```
Replace `$(nproc)` with the number of CPU cores + 1.

### 17. Verify Suricata Compilation
Test Suricata compilation:  
```bash
make package/suricata/{clean,prepare,compile} -j$(nproc) V=sc
```
The compiled `.ipkg` package will be in `/bin/packages/x86_64/packages`.

### 18. Build Final Image

Build the complete image:  
```bash
make -j$(nproc) V=sc
```
The final image will be in `bin/targets/bcm27xx/bcm2710-musl` (or `bin/targets/x86/64-musl`) as `.img.gz` (or `.img` and `.vdi` if VirtualBox support is enabled).

### 19. Using the Image

Use the `.img` file to boot your OpenWrt instance.  

---

## VirtualBox Configuration

For details on setting up the VirtualBox VM, refer to the [OpenWrt VirtualBox VM Guide](https://openwrt.org/docs/guide-user/virtualization/virtualbox-vm).  

--- 

This concludes the setup guide. Enjoy your OpenWrt image with Suricata!
